/*
 * Decompiled with CFR 0.152.
 */
package com.vmx;

import java.io.UnsupportedEncodingException;

public class StringEncoder {
    protected static char[] cp1251 = new char[]{'\u0410', '\u0411', '\u0412', '\u0413', '\u0414', '\u0415', '\u0416', '\u0417', '\u0418', '\u0419', '\u041a', '\u041b', '\u041c', '\u041d', '\u041e', '\u041f', '\u0420', '\u0421', '\u0422', '\u0423', '\u0424', '\u0425', '\u0426', '\u0427', '\u0428', '\u0429', '\u042a', '\u042b', '\u042c', '\u042d', '\u042e', '\u042f', '\u0430', '\u0431', '\u0432', '\u0433', '\u0434', '\u0435', '\u0436', '\u0437', '\u0438', '\u0439', '\u043a', '\u043b', '\u043c', '\u043d', '\u043e', '\u043f', '\u0440', '\u0441', '\u0442', '\u0443', '\u0444', '\u0445', '\u0446', '\u0447', '\u0448', '\u0449', '\u042a', '\u044b', '\u044c', '\u044d', '\u044e', '\u044f'};

    public static byte[] encodeString(String s, String enc) throws UnsupportedEncodingException {
        byte[] bs;
        try {
            bs = s.getBytes(enc);
        }
        catch (UnsupportedEncodingException x) {
            if (enc.compareTo("windows-1251") == 0) {
                byte[] bs2 = new byte[s.length()];
                for (int i = 0; i < s.length(); ++i) {
                    bs2[i] = StringEncoder.encodeCharCP1251(s.charAt(i));
                }
                return bs2;
            }
            throw x;
        }
        return bs;
    }

    public static int getEncodedLength(String s, String enc) throws UnsupportedEncodingException {
        try {
            byte[] bs = s.getBytes(enc);
            return bs.length;
        }
        catch (UnsupportedEncodingException x) {
            if (enc.compareTo("windows-1251") == 0) {
                return s.length();
            }
            throw x;
        }
    }

    public static String decodeString(byte[] bs, int off, int len, String enc) throws UnsupportedEncodingException {
        String s;
        try {
            s = new String(bs, off, len, enc);
        }
        catch (UnsupportedEncodingException x) {
            if (enc.compareTo("windows-1251") == 0) {
                String s2 = "";
                for (int i = 0; i < len; ++i) {
                    s2 = s2 + StringEncoder.decodeCharCP1251(bs[off + i]);
                }
                return s2;
            }
            throw x;
        }
        return s;
    }

    public static char decodeCharCP1251(byte b) {
        int ich = b & 0xFF;
        if (ich == 184) {
            return '\u0451';
        }
        if (ich == 168) {
            return '\u0401';
        }
        if (ich >= 192) {
            return cp1251[ich - 192];
        }
        return (char)ich;
    }

    public static byte encodeCharCP1251(char ch) {
        if (ch > '\u0000' && ch < '\u0080') {
            return (byte)ch;
        }
        if (ch == '\u0401') {
            return -88;
        }
        if (ch == '\u0404') {
            return -86;
        }
        if (ch == '\u0407') {
            return -81;
        }
        if (ch == '\u0451') {
            return -72;
        }
        if (ch == '\u0454') {
            return -70;
        }
        if (ch == '\u0457') {
            return -65;
        }
        return (byte)((byte)ch + 176);
    }
}

