/*
 * Decompiled with CFR 0.152.
 */
package com.vmx;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class BufDataInputStream
extends InputStream
implements DataInput {
    protected byte[] buffer;
    protected int bmax;
    protected int blen;
    protected int bpos;
    protected int bstreampos;
    protected int markedPos;
    protected int capacity;
    protected int is_available;
    protected boolean markSupp;
    protected InputStream is;

    public BufDataInputStream(int bufsize, InputStream iis) throws IOException {
        if (bufsize <= 0) {
            throw new IOException("Buffer size must be greater than 0");
        }
        this.bmax = bufsize;
        this.blen = 0;
        this.bpos = 0;
        this.bstreampos = 0;
        this.buffer = new byte[this.bmax];
        this.is = iis;
        this.capacity = this.is_available = this.is.available();
        this.markSupp = this.is.markSupported();
        if (this.markSupp) {
            this.is.mark(this.capacity + 256);
        }
        this.markedPos = -1;
    }

    public void close() throws IOException {
        this.is.close();
    }

    public int available() throws IOException {
        return this.blen - this.bpos + this.is_available;
    }

    public int getCapacity() throws IOException {
        return this.capacity;
    }

    public void seek(int pos) throws IOException {
        if (pos >= this.bstreampos && pos < this.bstreampos + this.blen) {
            this.bpos = pos - this.bstreampos;
        } else {
            this.is.reset();
            this.is.skip(pos);
            this.bufferize();
        }
    }

    public int tell() throws IOException {
        return this.capacity - this.available();
    }

    public void mark(int readlimit) {
        try {
            this.markedPos = this.tell();
        }
        catch (IOException ix) {
            this.markedPos = -1;
        }
    }

    public boolean markSupported() {
        return this.is.markSupported();
    }

    public void reset() throws IOException {
        if (this.markedPos < 0) {
            throw new IOException("call mark() before reset()");
        }
        this.seek(this.markedPos);
    }

    public long skip(long n) throws IOException {
        if (n < (long)(this.blen - this.bpos)) {
            this.bpos = (int)((long)this.bpos + n);
            return n;
        }
        long act = this.blen - this.bpos;
        this.bufferize();
        return act += this.is.skip(n -= (long)(this.blen - this.bpos));
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int rest;
        int n;
        int pos = off;
        for (rest = len; rest > 0; rest -= n) {
            if (this.bpos >= this.blen && this.bufferize() <= 0) {
                this.blen = 0;
                break;
            }
            n = rest;
            if (n > this.blen - this.bpos) {
                n = this.blen - this.bpos;
            }
            System.arraycopy(this.buffer, this.bpos, b, pos, n);
            pos += n;
            this.bpos += n;
        }
        return len - rest;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read() throws IOException {
        if (this.bpos >= this.blen && this.bufferize() <= 0) {
            return -1;
        }
        return this.buffer[this.bpos++] & 0xFF;
    }

    public int readBack() throws IOException {
        if (this.bpos == 0) {
            if (this.available() == this.capacity || !this.markSupp) {
                return -1;
            }
            int old = this.tell();
            this.bstreampos -= this.bmax;
            if (this.bstreampos < 0) {
                this.bstreampos = 0;
            }
            this.is.reset();
            this.is.skip(this.bstreampos);
            this.bufferize();
            this.bpos = old - this.bstreampos;
        }
        return this.buffer[--this.bpos] & 0xFF;
    }

    public void flush() throws IOException {
        if (this.is_available > 0) {
            if (this.bpos != 0 && this.bpos != this.blen) {
                System.arraycopy(this.buffer, this.bpos, this.buffer, 0, this.blen - this.bpos);
            }
            this.blen -= this.bpos;
            this.bstreampos += this.bpos;
            this.bpos = 0;
            int blenp = this.is.read(this.buffer, this.blen, this.bmax - this.blen);
            this.blen += blenp;
            this.is_available -= blenp;
        }
    }

    protected int bufferize() throws IOException {
        this.is_available = this.is.available();
        this.bstreampos = this.capacity - this.is_available;
        this.bpos = 0;
        this.blen = 0;
        if (this.is_available > 0) {
            this.blen = this.is.read(this.buffer, 0, this.bmax);
            this.is_available -= this.blen;
        }
        return this.blen;
    }

    public void updateBuffer() throws IOException {
        this.is.reset();
        this.is.skip(this.bstreampos);
        this.bufferize();
    }

    public boolean readBoolean() throws IOException {
        int r = this.read();
        if (r == -1) {
            throw new IOException("EOF");
        }
        return r != 0;
    }

    public byte readByte() throws IOException {
        int r = this.read();
        if (r == -1) {
            throw new IOException("EOF");
        }
        return (byte)r;
    }

    public char readChar() throws IOException {
        return (char)(this.readUnsignedByte() << 8 | this.readUnsignedByte());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void readFully(byte[] b) throws IOException {
        if (this.read(b) < b.length) {
            throw new IOException("EOF");
        }
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (this.read(b, off, len) < len) {
            throw new IOException("EOF");
        }
    }

    public int readInt() throws IOException {
        return this.readUnsignedByte() << 24 | this.readUnsignedByte() << 16 | this.readUnsignedByte() << 8 | this.readUnsignedByte();
    }

    public long readLong() throws IOException {
        byte[] bb = new byte[8];
        this.readFully(bb);
        return bb[0] << 24 | bb[1] << 16 | bb[2] << 8 | bb[3];
    }

    public short readShort() throws IOException {
        return (short)(this.readUnsignedByte() << 8 | this.readUnsignedByte());
    }

    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public int skipBytes(int len) throws IOException {
        return (int)this.skip(len);
    }

    public String readUTF() throws IOException, UTFDataFormatException {
        String s = "";
        int n = this.readUnsignedShort();
        byte[] b = new byte[n];
        this.readFully(b);
        return new String(b, 0, b.length, "UTF-8");
    }

    public char readCharUTF() throws IOException, UTFDataFormatException {
        int b = this.read();
        if (b == -1) {
            return '\uffff';
        }
        if ((b & 0x80) == 0) {
            return (char)b;
        }
        if ((b & 0xE0) == 192) {
            int c = this.read();
            if ((c & 0xC0) != 128) {
                throw new UTFDataFormatException();
            }
            return (char)((b & 0x1F) << 6 | c & 0x3F);
        }
        if ((b & 0xF0) == 224) {
            int c = this.read();
            int d = this.read();
            if ((c & 0xC0) != 128 || (d & 0xC0) != 128) {
                throw new UTFDataFormatException();
            }
            return (char)((b & 0xF) << 12 | (c & 0x3F) << 6 | d & 0x3F);
        }
        throw new UTFDataFormatException();
    }

    public char readCharBackUTF() throws IOException, UTFDataFormatException {
        int d = this.readBack();
        int c = this.readBack();
        int b = this.readBack();
        if (d == -1) {
            return '\uffff';
        }
        if ((d & 0x80) == 0) {
            this.read();
            this.read();
            return (char)d;
        }
        if ((c & 0xE0) == 192 && (d & 0xC0) == 128) {
            this.read();
            return (char)((c & 0x1F) << 6 | d & 0x3F);
        }
        if ((b & 0xF0) == 224 && (c & 0xC0) == 128 && (d & 0xC0) == 128) {
            return (char)((b & 0xF) << 12 | (c & 0x3F) << 6 | d & 0x3F);
        }
        throw new UTFDataFormatException();
    }

    public String readUTF(int count) throws IOException, UTFDataFormatException {
        String s = "";
        boolean b = false;
        boolean c = false;
        boolean d = false;
        for (int i = 0; i < count && this.available() > 0; ++i) {
            s = s + this.readCharUTF();
        }
        return s;
    }

    public int skipUTF(int count) throws IOException, UTFDataFormatException {
        int r = 0;
        for (int i = 0; i < count; ++i) {
            byte b = this.readByte();
            if ((b & 0x80) == 0) {
                ++r;
                continue;
            }
            if ((b & 0xE0) == 192) {
                this.readByte();
                r += 2;
                continue;
            }
            if ((b & 0xF0) == 224) {
                this.readShort();
                r += 3;
                continue;
            }
            throw new UTFDataFormatException();
        }
        return r;
    }
}

