/*
 * Decompiled with CFR 0.152.
 */
package com.vmx;

import com.vmx.BufDataInputStream;
import com.vmx.StringEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class InputStreamDecoder {
    int enc;
    BufDataInputStream bdis;

    public InputStreamDecoder(InputStream is, String enc) throws UnsupportedEncodingException, IOException {
        if (enc.compareTo("UTF-8") == 0) {
            this.enc = 1;
        } else if (enc.compareTo("windows-1251") == 0) {
            this.enc = 2;
        } else {
            throw new UnsupportedEncodingException("Encoding " + enc + " is not supported by InputStreamDecoder");
        }
        this.bdis = new BufDataInputStream(2048, is);
    }

    public InputStreamDecoder(BufDataInputStream bdis, String enc) throws UnsupportedEncodingException {
        if (enc.compareTo("UTF-8") == 0) {
            this.enc = 1;
        } else if (enc.compareTo("windows-1251") == 0) {
            this.enc = 2;
        } else {
            throw new UnsupportedEncodingException("Encoding " + enc + " is not supported by InputStreamDecoder");
        }
        this.bdis = bdis;
    }

    public char readChar() throws IOException {
        char c = '\uffff';
        if (this.bdis.available() > 0) {
            if (this.enc == 2) {
                int i = this.bdis.read();
                if (i > -1) {
                    c = StringEncoder.decodeCharCP1251((byte)i);
                }
            } else if (this.enc == 1) {
                c = this.bdis.readCharUTF();
            } else {
                throw new IOException("Internal InputStreamDecoder error");
            }
        }
        return c;
    }

    public String readChars(int len) throws IOException {
        if (this.bdis.available() <= 0) {
            return null;
        }
        if (this.enc == 1) {
            return this.bdis.readUTF(len);
        }
        if (this.enc == 2) {
            byte[] bs = new byte[len];
            int rl = this.bdis.read(bs);
            return StringEncoder.decodeString(bs, 0, rl, "windows-1251");
        }
        throw new IOException("Internal InputStreamDecoder error");
    }

    public char readCharBack() throws IOException {
        if (this.bdis.tell() <= 0) {
            return '\uffff';
        }
        if (this.enc == 1) {
            return this.bdis.readCharBackUTF();
        }
        if (this.enc == 2) {
            int i = this.bdis.readBack();
            if (i == -1) {
                return '\uffff';
            }
            return StringEncoder.decodeCharCP1251((byte)i);
        }
        throw new IOException("Internal InputStreamDecoder error");
    }

    public int skipChars(int n) throws IOException {
        if (this.enc == 1) {
            return this.bdis.skipUTF(n);
        }
        if (this.enc == 2) {
            return this.bdis.skipBytes(n);
        }
        throw new IOException("Internal InputStreamDecoder error");
    }
}

