
//#define WANT_STREAM

#include "include.h"

#include "newmatap.h"
//#include "newmatio.h"

#include "tmt.h"

#ifdef use_namespace
using namespace NEWMAT;
#endif


void WillNotConverge()
{
   Matrix A(10,10);
   Throw(ConvergenceNM10Exception(A));
}

void ReSizeMatrix(Matrix& A)
// for seeing if we can redimension a vector as a matrix
{ A.ReSize(4,5); }

void trymati()
{
#ifndef DisableNM10Exceptions
   Tracer et("Eighteenth test of Matrix package");
   Matrix RUStillThere(10,20); RUStillThere = 1553;
   Tracer::PrintTrace();

   ColumnVector checks(23); checks = 1.0; checks(1) = 0.0;

   Try { WillNotConverge(); }
   Catch(ConvergenceNM10Exception) { checks(2) = 0; }
   CatchAll { checks(1) = 1; }


   Try { Matrix M(10,10); SymmetricMatrix S = M; }
   Catch(ConvergenceNM10Exception) { checks(1) = 1; }
   Catch(InternalNM10Exception) { checks(1) = 1; }
   Catch(ProgramNM10Exception) { checks(3) = 0; }
   CatchAll { checks(1) = 1; }


   Try { Matrix M(10,10); M(10,11) = 2.0; }
   Catch(ConvergenceNM10Exception) { checks(1) = 1; }
   Catch(InternalNM10Exception) { checks(1) = 1; }
   Catch(IndexNM10Exception) { checks(4) = 0; }
   CatchAll { checks(1) = 1; }

   Try { Matrix M(10,10); M = 0.0; M = M.i(); }
   Catch(ConvergenceNM10Exception) { checks(1) = 1; }
   Catch(InternalNM10Exception) { checks(1) = 1; }
   Catch(ProgramNM10Exception) { checks(1) = 1; }
   Catch(SingularNM10Exception) { checks(5) = 0; }
   Catch(Bad_alloc) { checks(1) = 1; }
   CatchAndThrow;

   Try { ColumnVector A(30), B(50);  A = 5; B = 3; FFT(A,B,A,B); }
   Catch(ConvergenceNM10Exception) { checks(1) = 1; }
   Catch(InternalNM10Exception) { checks(1) = 1; }
   Catch(ProgramNM10Exception) { checks(6) = 0; }
   CatchAll { checks(1) = 1; }

   Try
   {
      ColumnVector A(30); A = 5; Matrix At = A.t();
      DiagonalMatrix D;
      SVD(At,D);
   }
   Catch(ConvergenceNM10Exception) { checks(1) = 1; }
   Catch(InternalNM10Exception) { checks(1) = 1; }
   Catch(Logic_error) { checks(6) = 0; }
   Catch(Bad_alloc) { checks(1) = 1; }
   CatchAndThrow;

   Try { BandMatrix X(10,3,4); X(1,10) = 4.0; }
   Catch(ConvergenceNM10Exception) { checks(1) = 1; }
   Catch(InternalNM10Exception) { checks(1) = 1; }
   Catch(IndexNM10Exception) { checks(7) = 0; }
   CatchAll { checks(1) = 1; }

   Try
   {
      SymmetricMatrix S(10); S = 5;
      LowerTriangularMatrix L = Cholesky(S);
   }
   Catch(ConvergenceNM10Exception) { checks(1) = 1; }
   Catch(InternalNM10Exception) { checks(1) = 1; }
   Catch(ProgramNM10Exception) { checks(1) = 1; }
   Catch(NPDNM10Exception) { checks(8) = 0; }
   Catch(Bad_alloc) { checks(1) = 1; }
   CatchAndThrow;

   Try { BandMatrix M(10,3,5); M = 0.0; Matrix XM = M.i(); }
   Catch(ConvergenceNM10Exception) { checks(1) = 1; }
   Catch(InternalNM10Exception) { checks(1) = 1; }
   Catch(ProgramNM10Exception) { checks(1) = 1; }
   Catch(SingularNM10Exception) { checks(9) = 0; }
   Catch(Bad_alloc) { checks(1) = 1; }
   CatchAndThrow;

   Try { ColumnVector X(10); ColumnVector Y; X = 5; X = X - Y; }
   Catch(ConvergenceNM10Exception) { checks(1) = 1; }
   Catch(InternalNM10Exception) { checks(1) = 1; }
   Catch(IncompatibleDimensionsNM10Exception) { checks(10) = 0; }
   Catch(Bad_alloc) { checks(1) = 1; }
   CatchAndThrow;

   Try
   {
      UpperTriangularMatrix U(3); RowVector RV(3); RV = 10;
      U.Row(2) = RV;
   }
   Catch(ConvergenceNM10Exception) { checks(1) = 1; }
   Catch(InternalNM10Exception) { checks(1) = 1; }
   Catch(ProgramNM10Exception) { checks(11) = 0; }
   Catch(Bad_alloc) { checks(1) = 1; }
   CatchAndThrow;

   Try { DiagonalMatrix D(3); D << 12 << 13 << 14 << 15; }
   Catch(ConvergenceNM10Exception) { checks(1) = 1; }
   Catch(InternalNM10Exception) { checks(1) = 1; }
   Catch(ProgramNM10Exception) { checks(12) = 0; }
   CatchAndThrow;

   Try { ColumnVector D(3); D << 12 << 13; D << 1 << 2 << 3; }
   Catch(ConvergenceNM10Exception) { checks(1) = 1; }
   Catch(InternalNM10Exception) { checks(1) = 1; }
   Catch(ProgramNM10Exception) { checks(13) = 0; }
   CatchAndThrow;


   Try {  { ColumnVector D(3); D << 12 << 13; }  }
   Catch(ConvergenceNM10Exception) { checks(1) = 1; }
   Catch(InternalNM10Exception) { checks(1) = 1; }
   Catch(ProgramNM10Exception) { checks(14) = 0; }
   CatchAndThrow;

   Try { ColumnVector CV; ReSizeMatrix(CV); }
   Catch(ConvergenceNM10Exception) { checks(1) = 1; }
   Catch(InternalNM10Exception) { checks(1) = 1; }
   Catch(VectorNM10Exception) { checks(15) = 0; }
   CatchAndThrow;

   Try { RowVector RV(20); ReSizeMatrix(RV); }
   Catch(ConvergenceNM10Exception) { checks(1) = 1; }
   Catch(InternalNM10Exception) { checks(1) = 1; }
   Catch(VectorNM10Exception) { checks(16) = 0; }
   CatchAndThrow;

   Try
   {
      UpperTriangularMatrix U(10); U = 5;
      DiagonalMatrix D(10); D = 2;
      D += U;                 // illegal conversion
   }
   Catch(ConvergenceNM10Exception) { checks(1) = 1; }
   Catch(InternalNM10Exception) { checks(1) = 1; }
   Catch(ProgramNM10Exception) { checks(17) = 0; }
   CatchAndThrow;

   Try { Matrix A(2,3), B(2,3); if (A < B) A = B; }
   Catch(ConvergenceNM10Exception) { checks(1) = 1; }
   Catch(InternalNM10Exception) { checks(1) = 1; }
   Catch(NotDefinedNM10Exception) { checks(18) = 0; }
   CatchAndThrow;

   Try { SymmetricBandMatrix A(3,1); A = 1; A = A.Reverse(); }
   Catch(ConvergenceNM10Exception) { checks(1) = 1; }
   Catch(InternalNM10Exception) { checks(1) = 1; }
   Catch(NotDefinedNM10Exception) { checks(19) = 0; }
   CatchAndThrow;

   Try
   {
      Matrix A(5,5); A = 1.0;
      UpperTriangularMatrix B(10);
      B.SubMatrix(3,7,3,7) = A;
   }
   Catch(ProgramNM10Exception) { checks(20) = 0; }
   CatchAndThrow;

   Try {  { RowVector D(1); D << 12 << 13; }  }
   Catch(InternalNM10Exception) { checks(1) = 1; }
   Catch(ProgramNM10Exception) { checks(21) = 0; }
   CatchAndThrow;

   Try {  { RowVector D(0); D << 12; }  }
   Catch(InternalNM10Exception) { checks(1) = 1; }
   Catch(ProgramNM10Exception) { checks(22) = 0; }
   CatchAndThrow;

   Try { Matrix M(10,10); Matrix XM(3,3); M = 0.0; XM = M.i(); }
   Catch(SingularNM10Exception) { checks(23) = 0; }
   CatchAll { checks(1) = 1; }

   Print(checks);
   Matrix RUStillThere1(10,20); RUStillThere1 = 1553;
   RUStillThere = RUStillThere - RUStillThere1;
   Print(RUStillThere);
#endif

}



