/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class vgCanvas
extends Canvas
implements CommandListener {
    int Cs;
    int TMR;
    int w;
    int h;
    int sx;
    int sy;
    int cx;
    int cy;
    int offleft;
    int[] field;
    int[] field2;
    int KEY_LEFT;
    int KEY_RIGHT;
    int KEY_UP;
    int KEY_DOWN;
    int KEY_FIRE;
    boolean[] enable;
    boolean[] enable2;
    Random rnd;
    vgMIDlet mid;
    Timer tmr;
    TimerTask ttk;
    Font mfn;
    Image gcell;
    int mfnh;
    int score;
    int pushes;
    int entropy;
    boolean victory;
    Image victoryImg;

    public vgCanvas(vgMIDlet owner) {
        this.mid = owner;
        this.Cs = 10;
        this.TMR = 200;
        this.KEY_LEFT = this.getKeyCode(2);
        this.KEY_RIGHT = this.getKeyCode(5);
        this.KEY_DOWN = this.getKeyCode(6);
        this.KEY_UP = this.getKeyCode(1);
        this.KEY_FIRE = this.getKeyCode(8);
        this.setFullScreenMode(true);
        this.mfn = Font.getFont((int)0, (int)0, (int)8);
        this.mfnh = this.mfn.getHeight();
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.rnd = new Random();
        this.tmr = new Timer();
        this.ttk = null;
        this.gcell = null;
        this.customInit();
        this.startTimer();
        this.setCommandListener(this);
        this.addCommand(new Command("Restart", 1, 1));
        this.addCommand(new Command("Settings", 1, 1));
        this.addCommand(new Command("Exit", 7, 1));
    }

    public void customInit() {
        try {
            this.victoryImg = Image.createImage((String)"/victory.png");
        }
        catch (IOException iox) {
            this.victoryImg = null;
        }
        try {
            this.gcell = Image.createImage((String)("/gridcell" + Integer.toString(this.Cs) + ".png"));
        }
        catch (IOException iox) {
            this.gcell = null;
        }
        this.sx = this.w / this.Cs;
        this.sy = (this.h - this.mfnh - 1) / this.Cs;
        this.offleft = this.w % this.Cs / 2;
        this.cx = 0;
        this.cy = 0;
        this.field = new int[this.sx * this.sy];
        this.field2 = new int[this.sx * this.sy];
        this.enable = new boolean[this.sx * this.sy];
        this.enable2 = new boolean[this.sx * this.sy];
        this.randomField();
    }

    public void startTimer() {
        this.stopTimer();
        this.ttk = new vgTimerTask(this);
        this.tmr.scheduleAtFixedRate(this.ttk, 0L, (long)this.TMR);
    }

    public void stopTimer() {
        if (this.ttk != null) {
            this.ttk.cancel();
            this.ttk = null;
        }
    }

    public void randomField() {
        int sxy = this.sx * this.sy;
        for (int i = 0; i < sxy; ++i) {
            this.field[i] = this.rnd.nextInt(4);
            this.enable[i] = false;
        }
        this.score = 0;
        this.pushes = 0;
        this.entropy = this.getEntropy();
        this.victory = false;
    }

    public void rotate() {
        int n = 0;
        for (int i = 0; i < this.sy; ++i) {
            int j = 0;
            while (j < this.sx) {
                if (i > 0 && this.field[n] < 2 && this.field[n - this.sx] > 1 && this.enable[n - this.sx] || i < this.sy - 1 && this.field[n] > 1 && this.field[n + this.sx] < 2 && this.enable[n + this.sx] || j > 0 && (this.field[n] == 0 || this.field[n] == 3) && (this.field[n - 1] == 1 || this.field[n - 1] == 2) && this.enable[n - 1] || j < this.sx - 1 && (this.field[n] == 1 || this.field[n] == 2) && (this.field[n + 1] == 0 || this.field[n + 1] == 3) && this.enable[n + 1]) {
                    this.field2[n] = (this.field[n] + 1) % 4;
                    ++this.score;
                    this.enable2[n] = true;
                } else {
                    this.field2[n] = this.field[n];
                    this.enable2[n] = false;
                }
                ++j;
                ++n;
            }
        }
        int[] t = this.field2;
        this.field2 = this.field;
        this.field = t;
        boolean[] tt = this.enable2;
        this.enable2 = this.enable;
        this.enable = tt;
        this.entropy = this.getEntropy();
    }

    public void paint(Graphics g) {
        g.setColor(0xDFF5FF);
        g.fillRect(0, 0, this.w, this.h);
        if (this.gcell == null) {
            g.setColor(0);
            int n = 0;
            for (int i = 0; i < this.sy; ++i) {
                int j = 0;
                while (j < this.sx) {
                    if (this.cx == j && this.cy == i) {
                        g.setColor(0xFFA0A0);
                        g.fillRect(this.offleft + j * this.Cs, i * this.Cs, this.Cs, this.Cs);
                        g.setColor(0);
                    }
                    if (this.field[n] == 0 || this.field[n] == 3) {
                        g.drawLine(this.offleft + j * this.Cs, i * this.Cs + this.Cs / 2, this.offleft + j * this.Cs + this.Cs / 2, i * this.Cs + this.Cs / 2);
                    }
                    if (this.field[n] == 0 || this.field[n] == 1) {
                        g.drawLine(this.offleft + j * this.Cs + this.Cs / 2, i * this.Cs, this.offleft + j * this.Cs + this.Cs / 2, i * this.Cs + this.Cs / 2);
                    }
                    if (this.field[n] == 1 || this.field[n] == 2) {
                        g.drawLine(this.offleft + j * this.Cs + this.Cs / 2, i * this.Cs + this.Cs / 2, this.offleft + j * this.Cs + this.Cs - 1, i * this.Cs + this.Cs / 2);
                    }
                    if (this.field[n] == 2 || this.field[n] == 3) {
                        g.drawLine(this.offleft + j * this.Cs + this.Cs / 2, i * this.Cs + this.Cs / 2, this.offleft + j * this.Cs + this.Cs / 2, i * this.Cs + this.Cs - 1);
                    }
                    ++j;
                    ++n;
                }
            }
        } else {
            int n = 0;
            for (int i = 0; i < this.sy; ++i) {
                int j = 0;
                while (j < this.sx) {
                    if (this.cx == j && this.cy == i) {
                        g.drawRegion(this.gcell, this.field[n] * this.Cs, this.Cs, this.Cs, this.Cs, 0, this.offleft + j * this.Cs, i * this.Cs, 4 | 0x10);
                    } else {
                        g.drawRegion(this.gcell, this.field[n] * this.Cs, 0, this.Cs, this.Cs, 0, this.offleft + j * this.Cs, i * this.Cs, 4 | 0x10);
                    }
                    ++j;
                    ++n;
                }
            }
        }
        g.setColor(0);
        g.setFont(this.mfn);
        if (this.pushes > 0) {
            g.drawString(Integer.toString(this.score / this.pushes), this.w / 2, this.h, 1 | 0x20);
        }
        g.drawString(Integer.toString(100 * this.entropy / this.sx / this.sy) + "%", this.w, this.h, 0x20 | 8);
        if (this.victory) {
            g.drawImage(this.victoryImg, this.w / 2, this.h / 2, 1 | 2);
        }
    }

    int getEntropy() {
        int i;
        if (this.field == null) {
            return 0;
        }
        int[] freq = new int[4];
        int r = 0;
        int sxy = this.sx * this.sy;
        freq[3] = 0;
        freq[2] = 0;
        freq[1] = 0;
        freq[0] = 0;
        for (i = 0; i < sxy; ++i) {
            int n = this.field[i];
            freq[n] = freq[n] + 1;
        }
        r = freq[0];
        for (i = 1; i < 4; ++i) {
            if (freq[i] <= r) continue;
            r = freq[i];
        }
        if (r == sxy) {
            this.victory = true;
        }
        return r;
    }

    protected void keyPressed(int keyCode) {
        if (this.victory) {
            return;
        }
        boolean rep = true;
        if (keyCode == this.KEY_LEFT || keyCode == 52) {
            this.cx = (this.cx + this.sx - 1) % this.sx;
        } else if (keyCode == this.KEY_RIGHT || keyCode == 54) {
            this.cx = (this.cx + 1) % this.sx;
        } else if (keyCode == this.KEY_UP || keyCode == 50) {
            this.cy = (this.cy + this.sy - 1) % this.sy;
        } else if (keyCode == this.KEY_DOWN || keyCode == 56) {
            this.cy = (this.cy + 1) % this.sy;
        } else if (keyCode == this.KEY_FIRE) {
            this.enable[this.cy * this.sx + this.cx] = true;
            this.field[this.cy * this.sx + this.cx] = (this.field[this.cy * this.sx + this.cx] + 1) % 4;
            ++this.pushes;
            this.entropy = this.getEntropy();
        } else {
            rep = false;
        }
        if (rep) {
            this.repaint();
        }
    }

    protected void keyReleased(int keyCode) {
    }

    protected void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }

    public void commandAction(Command c, Displayable d) {
        String s = c.getLabel();
        if (s == "Restart") {
            this.randomField();
        } else if (s == "Settings") {
            this.mid.startSettings();
        } else if (s == "Exit") {
            this.mid.destroyApp(false);
        }
    }
}

